terraform {
  required_version = ">= 1.0.0, < 2.0.0"

  required_providers {
    aws = {
      source  = "hashicorp/aws"
      version = "~> 4.0"
    }
  }

  backend "s3" {

    # Ten plik konfiguracyjny w trakcie testu będzie wypełniony automatycznie
    # przez Terratest. Jeżeli chcesz ten przykład wykonać ręcznie, usuń znaki
    # komentarza na początku poniższych wierszy i uzupełnij je żądanymi danymi.

    # bucket         = "<NAZWA KUBEŁKA S3>"
    # key            = "<ŚCIEŻKA DOSTĘPU>/terraform.tfstate"
    # region         = "us-east-2"
    # dynamodb_table = "<NAZWA TABELI DYNAMODB>"
    # encrypt        = true

  }
}

provider "aws" {
  region = "us-east-2"
}

resource "aws_db_instance" "example" {
  identifier_prefix   = "terraform-up-and-running"
  engine              = "mysql"
  allocated_storage   = 10
  instance_class      = "db.t2.micro"
  skip_final_snapshot = true

  db_name             = var.db_name

  username = var.db_username
  password = var.db_password
}
